function [meanimage,stdimage,images,rotimages] = ImageCorrNew(channels,maxOffset,x,y)
    %ImageCorrNew(channels,maxOffset,x,y);
    %
    %Usage example: [mean,std,im,rot]= ImageCorrNew({'syn.tif','psd.tif'},10,490,100);
    %
    if nargin < 3, x=1;y=1; end
    [c1,c1images]=tiffread2(channels{1});
    optSize=2*maxOffset*10+10;
    maxHeight=length(c1(1).data(:,1));    
    maxWidth=length(c1(1).data(1,:));   
    images=[];
    rotimages=[];
    meanimage=[];
    stdimage=[];
    offset=[x,y];
    if maxWidth/optSize < 1 || maxHeight/optSize < 1
        'Image is not big enough.  Please choose a smaller offset size.'
    else
        
        [tmpimgs,tmprots] = StackCorr(channels,optSize,offset(1),offset(2));
        images=cat(3,images,tmpimgs);
        rotimages=cat(3,rotimages,tmprots);

        ratioimg=(images-rotimages)./(rotimages+images); %difference over sum normalization
        meanimage=mean(ratioimg,3); %average over all the slices of the stack
        stdimage=std(ratioimg,0,3)/sqrt(length(ratioimg(1,1,:))); %find std dev
    end
    

function [images,rotimages] = StackCorr(channels,windowSize,offsetX,offsetY)

    if nargin < 2, offsetX=1; offsetY=1; end

    %channels= {'Synapsin1.tif', 'Synapsin2.tif', 'Syn1T.tif', 'Maguk.tif', 'Gephryn.tif'};
    %channels= {'SynSImgTrans2.tif'};
    useMask=0;
    if useMask==1
        maskImage=tiffread2('mask.tif');
    end
    
    imgsize=windowSize; %how big our subimages are going to be.
    images=[];
    rotimages=[];

    for c1 = 1:length(channels)
        [img1,n1images]=tiffread2(channels{c1});
        c1
        istk2=[];
        rstk2=[];
        for c2= 1:length(channels)
            [img2,n2images]=tiffread2(channels{c2});
            istk=[];
            rstk=[];
            for i = 1:n1images
                %compute the images patches
                sm1=img1(i).data(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1);
                sm2=img2(i).data(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1);

                if useMask==1
                    msm=maskImage(i).data(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1);

                    conv=CorrelationComparison(min(sm1,msm),min(sm2,msm),1);
                    convrot=CorrelationComparison(min(sm1,msm),min(sm2',msm),1);
                else
                    conv=CorrelationComparison(sm1,sm2,1);
                    convrot=CorrelationComparison(sm1,sm2',1);
                end

                istk=cat(3,istk,conv);
                rstk=cat(3,rstk,convrot);
            end
            istk2=cat(1,istk2,istk);
            rstk2=cat(1,rstk2,rstk);
            name={channels{c1},channels{c2}};
        end
        images=cat(2,images,istk2);
        rotimages=cat(2,rotimages,rstk2);
    end

function cconv=CorrelationComparison(img1, img2, scale)
    if nargin < 3, scale=1; end
    img1=imresize(img1,scale,'bicubic'); %scaling ability for subpixel comparison
    img2=imresize(img2,scale,'bicubic');
    bigsize=size(img2);
    offset=bigsize*0.05;
    newimg2=img2(round(offset(1)):round(bigsize(1)-offset(1)),round(offset(2)):round(bigsize(2)-offset(2)));
    newimg2=flipud(fliplr(newimg2)); %conv2 is MUCH faster, but requires one image to be flipped
    cconv=conv2(single(img1),single(newimg2),'valid');
